## TypeScript 是当下的政治正确但前端终将语言无关

毫无疑问 TypeScript 将成为很长一段时间的主流，大型前端开源项目大都已经或正在全面拥抱 TypeScript，他能让我们拥有很多面向对象语言、强类型语言才具备的先进特性，能帮助我们提升代码质量，降低团队协作上的成本和风险，如果我们的项目还未转过来，是时候动手了。
但一个开源项目的质量跟语言本身并无直接关系，更别说 TypeScript 本身依旧还只是带静态类型检查的弱类型语言，OO 并不是必须的，用原生 JS 也一样能写出优雅的封装与继承，更让人期待的是 WebAssembly（https://www.zhihu.com/question/362893829） 的潜力被真正开发出来后，前端终将语言无关，前端在研发的是人机交互界面上的产物。

## 浏览器技术和云计算的进化将加速前端构建和资源加载的变革

Webpack 5 正式版发布，通过物理缓存大幅提升构建性能，在短期内还会是主流构建工具；但随着 ES Modules 成为主流，CJS 淡出，ESM CDN 大范围使用后构建工具将转向 Bundless，Webpack 不可避免也会逐渐退出历史舞台。特别是当 HTTP/2 到来，支持请求与响应的多路复用来，HTTP 首部字段被大大压缩，传输效率会得到极大的提升，届时我们将不再需要对资源文件进行合并操作，构建工具也会随之加速进化。

## C/S 到 B/S 再到 C/S

历史总在不断重复轮回中循环上升，互联网，特别是云的出现让软件从 C/S 走向了 B/S，甚至如 WebAssembly 技术的出现，我们能更低成本的将原先的客户端软件移植到浏览器上去，一切看上去都是朝着 B/S 发展。然而我们也要看到另外一个趋势，自成生态的巨型应用如微信、支付宝、Facebook 等正在收敛浏览器上软件至他们的客户端上，背后的典型技术是小程序、PWA，我们甚至已经看到了出现在 PC 客户端上小程序。而借助如 Electron 这类项目，很多 B/S 模式的软件服务在推出自己的客户端以谋求用户更专注的使用体验，特别是很多传统以 C/S 模式提供服务的软件推出客户端会更贴合用户的心智。这是我们看到的历史轮回，但接下来的这段 C/S 历程跟过去的 C/S 所用到的技术已经完全不一样了，不管是小程序、PWA 还是 Service Worker、Electron、这 Client 端上开源项目会迎来一个春天。

## 新兴交互场景将唤起 Micro UI

Micro Frontends （https://micro-frontends.org/） 正风生水起，然而它不过是已经风靡多年但仍备受争议的 Microservice Architecture（https://microservices.io/） 在前端的应用，可以帮我们更好地去解决复杂应用的开发和维护问题。在人机交互，用户如何在一个复杂的产品中找到此时此刻最需要的一个 UI，仍然是一个未被很好地解决的问题。用户常常迷失在一个个大型 APP 复杂的 UI 中，然而很多时候我们只是需要一个能高效完成某项工作的 UI，姑且称为 Micro UI 吧。在银河帝国等科幻小说及科幻电影中，常常能看到一种叫“信息窗”的黑科技，这样的每个信息窗就是一个 Micro UI。随着 AI、AR、VR、IOT 持续推进话，设备将越来越懂人，信息和数据的呈现也将越来越生动化，这些在科幻中才出现的东西在未来 10 年一定有一些会变成现实 ，这种 UI 的开发方式也将为前端的开发方式带来质的变化。

## RPA & Marchine Driven UI

在 AI 和 IOT 时代，如果你然坚持认为应用一定是一个需要由专业人士设计开发，并且由用户通过手机主动使用 Web 产品的话，那么你将有较大概率过未来。
RPA 这个远古时代活跃在游戏外挂的古老的技术在 AI、标准化产品飞速发展的正在焕发着升级，UiPath（https://www.uipath.com/）、Zapier（https://zapier.com/）、Microsoft Power Platform（https://flow.microsoft.com/zh-cn/）、UI Bot（https://www.uibot.com.cn/） 等工具正在改变很多行业的工作方式，而以 Google Assistant 为代表的智能助理正在改变人们使用电脑的方式。作为前端，我们要考虑是：UI 不仅是被人消费的，还可以被机器消费，甚至只需要描述你的意图，这些非常需要一种高效的方式让你的应用可以被机器人来驱动。甚至应用已经不再是一个当下我们能看到的，而是一个个机器人了，而我们提供的则是：RPA 机器人制作工具、可以被 RPA 来驱动的标准 UI。如何设计与实现可以被机器人、人同时使用的 UI 是我们面临的一大挑战。

## 图形技术依旧会是界面上的热点

尽管脑机交互已经在实验室里孵化，但未来十年眼睛依旧还是人类获取外界信息最主要的通道，图形化可以比文字快十倍甚至万倍的速度清晰有效地传达信息，这是人类经历漫长进化习得的强大视觉化思考本能。在数据愈加丰富、使用场景愈加多样的下一个十年，如何高效的从数据中获得洞察依旧会有强烈的诉求，前端这个最接近数据可视化能力模型要求的工种依旧会是这个领域的主力。而另一方面，未来会出现新的屏，不管是 IOT 下的实屏还是 VR、AR 下的虚屏，当下已经相当完备和标准化的绘图 API 最有机会被新屏优先支持和采用，在这基础上利用图形技术实现一套新的 UI 基础设施甚至语言都是有可能的。

## 前端智能化

前端近年来一直尝试提升效率，可视化研发、搭建体系、工程&工具、端多解决方案等等都是为了解决效率，但天花板已然出现，下一步必然会引入智能化能力，在原来的技术体系&产品上，注入自然语言识别、图像识别的能力，使得效能的发生一系列质的变化，来突破这个天花板。更大层面上，运用智能化能力来解决工作中的问题，会逐步成为前端的必备能力和思考方式。
就算不想去蹭人工智能的热，事实上是你不得不接受并开始学习人工智能，大量简单如千人千面的 Banner、营销活动页已经纯粹通过人工智能自动化生产，并不需要前端去参与研发，复杂如中后台的表单、表格、图表展现也已经可以通过提供接口智能推导出最佳的页面实现，只需要一行代码输入数据就能出可视化图表，甚至从设计稿直接生成页面也将变成现实。前端智能化的项目将会越来越多，任何时候开始都不晚，但不开始就晚了。

## 端到端的研发

随着云原生和业务平台能力逐步完备，前端运用 Serverless 能力来完成端到端的研发工作会逐步成为一种趋势，在这个趋势的背后，会面临两个挑战，一方面是需要将现有的工具和平台延展到 Serverless 上，在支持 Serverless 的同时，必须将端到端一体化的来看待，包括：研发工具、监控体系、质量体系等等；另一方面对人员自身能力和意识有了新的要求。前端这个岗位的职能边界和能力范围的会发现变化。

基于前端智能化与端到端的研发方向上，是未来前端开源上的最具吸引力的项目；而在整体的层面上，前端具备吸引力的项目会有两个方面的特征：

在现有相关体系上提出新的理念和思想；随着框架、构建库等基础设施收敛，类似的重复性的开源项目会减少，但创新并不会停止，等到更多关注和认可的一定是能力在基础设施上提出新的理念和思想的项目。
在现有相关体系上与其他领域产生链接；有些技术未必是刚刚出现，但今天重新受到前端业内的关注，比如 WebAssembly，因为大家发现了新的运用场景。未来将现有前端技术与其他技术领域相结合的项目和设计，会受到开源社区的更多关注。
